<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * Typically, users are redirected here after authentication.
     * (مترجم: المسار القياسي لصفحة "الرئيسية" في تطبيقك.
     *         عادةً، يتم إعادة توجيه المستخدمين هنا بعد تسجيل الدخول.)
     *
     * @var string
     */
    // تم تعريفه كـ '/' بدلاً من '/home' ليتوافق مع Route::get('/', ...) في routes/web.php
    // كما ناقشنا سابقًا، هذا ليس سببًا مباشرًا لخطأ 403.
    public const HOME = '/';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     * (مترجم: تعريف روابط نماذج Route، ومرشحات الأنماط، وباقي إعدادات التوجيه.)
     *
     * @return void
     */
    public function boot()
    {
        // إعداد حدود معدل الطلبات (Rate Limiting) - عادةً للـ APIs
        $this->configureRateLimiting();

        // تعريف مسارات التطبيق
        $this->routes(function () {
            // مسارات الـ API
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            // مسارات الويب (التي تحتوي على المسارات المحمية بـ 'permission')
            Route::middleware('web')
                ->group(base_path('routes/web.php'));
        });
    }

    /**
     * Configure the rate limiters for the application.
     * (مترجم: إعداد حدود معدل الطلبات للتطبيق.)
     *
     * @return void
     */
    protected function configureRateLimiting()
    {
        // تعيين حد 60 طلب في الدقيقة لكل IP أو مستخدم مسجل دخوله لمسارات الـ API
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });
    }
}