<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\User;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        \App\Models\Employee::class => \App\Policies\EmployeePolicy::class,
        \App\Models\Attendance::class => \App\Policies\AttendancePolicy::class,
        \App\Models\Leave::class => \App\Policies\LeavePolicy::class,
        \App\Models\Payroll::class => \App\Policies\PayrollPolicy::class,
        \App\Models\Loan::class => \App\Policies\LoanPolicy::class,
        \App\Models\Deduction::class => \App\Policies\DeductionPolicy::class,
        \App\Models\Asset::class => \App\Policies\AssetPolicy::class,
        \App\Models\TrainingProgram::class => \App\Policies\TrainingPolicy::class,
        \App\Models\User::class => \App\Policies\UserPolicy::class,
        \Illuminate\Notifications\DatabaseNotification::class => \App\Policies\NotificationPolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        // السماح فقط للمستخدمين الذين يمتلكون الدور 'super-admin' أو 'admin' أو 'owner' بتجاوز التحقق
        // (أو أي دور يُعتبر "متميز" وله جميع الصلاحيات)
        Gate::before(function ($user, $ability) {
            // دعم تفرع أسماء الأدوار (underscore vs hyphen) لأن الأدوار في الـ seeder هي 'super_admin'
            if ($user->hasAnyRole(['super_admin', 'super-admin', 'admin', 'owner'])) {
                return true;
            }
            return null; // مهم: يجب إرجاع null إذا لم تكن الصلاحية للمستخدم
        });

        // تعريف صلاحيات مخصصة (اختياري)
        // على سبيل المثال، إذا كنت ترغب في التحقق من صلاحيات مخصصة
        // Gate::define('permission', function ($user, $permission) {
        //     return $user->hasPermissionTo($permission);
        // });
    }
}