<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;
use App\Models\Setting; // تأكد من استيراد نموذج Setting

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(191);

        // Blade directives for roles and permissions are removed.
        
        // تسجيل المتغيرات العامة لجميع العروض
        View::composer('*', function ($view) {
            // الحصول على رمز العملة من الدالة المساعدة (تُعيد الكود بأحرف كبيرة)
            $currencyCode = \get_currency_code();
            
            // أسماء العملات بناءً على الرمز (مطابقة للملف الموجود في المشروع)
            $currencyNames = [
                'EGP' => 'جنيه مصري',
                'KWD' => 'دينار كويتي',
                'USD' => 'دولار أمريكي',
                'EUR' => 'يورو',
                'SAR' => 'ريال سعودي',
                // أضف المزيد حسب الحاجة
            ];
            
            // مشاركة المتغيرات مع جميع العروض
            $view->with('currency_code', $currencyCode);
            // نُعيد استخدام اسم المتغير القديم `currency_name` لكن نضع فيه الرمز (لتقليل تغييرات القوالب)
            $view->with('currency_name', $currencyCode);
            // --- Today's attendance summary ---
            try {
                $today = \Carbon\Carbon::today();
                $totalEmployees = \App\Models\Employee::where('status', 'active')->count();
                $presentCount = \App\Models\Attendance::whereDate('date', $today->toDateString())->where('status', 'present')->count();
                // employees who have any attendance record today
                $recordedEmployeeIds = \App\Models\Attendance::whereDate('date', $today->toDateString())->pluck('employee_id')->unique()->filter()->values();
                $recordedCount = $recordedEmployeeIds->count();
                $notRecordedCount = max(0, $totalEmployees - $recordedCount);

                // absent without approved leave = employees active and not in recordedEmployeeIds and not having an approved leave covering today
                $absentWithoutLeave = \App\Models\Employee::where('status', 'active')
                    ->whereNotIn('id', $recordedEmployeeIds->toArray())
                    ->get()
                    ->filter(function ($emp) use ($today) {
                        $hasApprovedLeave = \App\Models\Leave::where('employee_id', $emp->id)
                            ->where('status', 'approved')
                            ->whereDate('start_date', '<=', $today->toDateString())
                            ->whereDate('end_date', '>=', $today->toDateString())
                            ->exists();
                        return !$hasApprovedLeave;
                    })->count();

                $view->with('attendance_summary_today', [
                    'total_employees' => $totalEmployees,
                    'present' => $presentCount,
                    'recorded' => $recordedCount,
                    'not_recorded' => $notRecordedCount,
                    'absent_without_leave' => $absentWithoutLeave,
                ]);
            } catch (\Throwable $_) {
                // ignore
            }
        });
    }
}