<?php

namespace App\Policies;

// التأكد من استخدام النموذج الصحيح
// افتراضياً اسم النموذج TrainingProgram. إذا كان اسم النموذج الفعلي مختلفاً (مثل Training فقط)،
// يرجى تعديل السطر التالي.
use App\Models\TrainingProgram as Training; // تأكد من أن هذا الاسم يطابق اسم نموذج التدريب الفعلي في مشروعك
// مثلاً، إذا كان النموذج يُسمى App\Models\Training، فاستخدم:
// use App\Models\Training;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class TrainingPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        return $user->can('view_training');
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  Training  $training
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, Training $training)
    {
        return $user->can('view_training');
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        return $user->can('manage_training');
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  Training  $training
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user, Training $training)
    {
        return $user->can('manage_training');
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  Training  $training
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user, Training $training)
    {
        return $user->can('manage_training');
    }

    /**
     * Determine whether the user can enroll in the training.
     *
     * @param  \App\Models\User  $user
     * @param  Training  $training
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function enroll(User $user, Training $training)
    {
        // السماح للمستخدمين بتسجيل أنفسهم أو للمديرين إدارته
        return $user->can('enroll_training') || $user->can('manage_training');
    }

    /**
     * Determine whether the user can complete the training.
     *
     * @param  \App\Models\User  $user
     * @param  Training  $training
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function complete(User $user, Training $training)
    {
        // عادةً، يمكن للمستخدم إكمال تدريب قام بالتسجيل فيه
        // أو يمكن للمدير إكماله
        return $user->can('enroll_training') || $user->can('manage_training');
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  Training  $training
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, Training $training)
    {
        return $user->can('manage_training');
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  Training  $training
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, Training $training)
    {
        // عادةً لا يُسمح بالحذف النهائي إلا للسوبر أدمن
        return $user->hasRole('super-admin'); // أو false إذا لم ترد السماح به مطلقاً
    }
}