<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Notifications\DatabaseNotification;

class NotificationPolicy
{
    use HandlesAuthorization;

    public function viewAny(User $user)
    {
        // إذا كان المستخدم لديه دور 'admin' أو 'super-admin'، سمح له بالعرض
        if ($user->hasRole('admin') || $user->hasRole('super-admin')) {
            return true;
        }
        // أي مستخدم يمكنه عرض إشعاراته فقط
        return true; // أو تحقق من إذن محدد مثل $user->can('view_notifications')
    }

    public function view(User $user, DatabaseNotification $notification)
    {
        // إذا كان المستخدم لديه دور 'admin' أو 'super-admin'، سمح له بالعرض
        if ($user->hasRole('admin') || $user->hasRole('super-admin')) {
            return true;
        }
        // يمكن للمستخدم عرض إشعاره فقط
        return $user->id === $notification->notifiable_id;
    }

    public function update(User $user, DatabaseNotification $notification)
    {
        // إذا كان المستخدم لديه دور 'admin' أو 'super-admin'، سمح له بالتعديل (وضع علامة "مقروء")
        if ($user->hasRole('admin') || $user->hasRole('super-admin')) {
            return true;
        }
        // عادةً ما يعني التحديث هو وضع علامة "مقروء" على إشعار المستخدم فقط
        return $user->id === $notification->notifiable_id;
    }

    public function delete(User $user, DatabaseNotification $notification)
    {
        // إذا كان المستخدم لديه دور 'admin' أو 'super-admin'، سمح له بالحذف
        if ($user->hasRole('admin') || $user->hasRole('super-admin')) {
            return true;
        }
        // يمكن للمستخدم حذف إشعاره فقط
        return $user->id === $notification->notifiable_id;
    }

    public function markAsRead(User $user, DatabaseNotification $notification)
    {
        // إذا كان المستخدم لديه دور 'admin' أو 'super-admin'، سمح له بوضع علامة "مقروء"
        if ($user->hasRole('admin') || $user->hasRole('super-admin')) {
            return true;
        }
        // يمكن للمستخدم وضع علامة "مقروء" على إشعاره فقط
        return $user->id === $notification->notifiable_id;
    }

    public function markAllAsRead(User $user)
    {
        // إذا كان المستخدم لديه دور 'admin' أو 'super-admin'، سمح له بوضع علامة "مقروء" على الكل
        if ($user->hasRole('admin') || $user->hasRole('super-admin')) {
            return true;
        }
        // أي مستخدم يمكنه تعليم جميع إشعاراته كمقروءة فقط
        return true; // أو تحقق من إذن محدد مثل $user->can('manage_notifications')
    }
}