<?php

namespace App\Notifications;

use App\Models\Payroll;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PayrollCreated extends Notification
{
    use Queueable;

    protected $payroll;

    public function __construct(Payroll $payroll)
    {
        $this->payroll = $payroll;
    }

    public function via($notifiable)
    {
        return ['database', 'mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject('قسيمة راتب جديدة - ' . $this->payroll->month->format('F Y'))
                    ->line('مرحباً ' . $this->payroll->employee->name)
                    ->line('تم إنشاء قسيمة راتب جديدة لشهر ' . $this->payroll->month->format('F Y'))
                    ->line('الراتب الأساسي: ' . number_format($this->payroll->basic_salary, 2))
                    ->line('البدلات: ' . number_format($this->payroll->allowances, 2))
                    ->line('المكافآت: ' . number_format($this->payroll->bonuses, 2))
                    ->line('الخصومات: ' . number_format($this->payroll->deductions, 2))
                    ->line('الراتب الصافي: ' . number_format($this->payroll->total_salary, 2))
                    ->action('عرض التفاصيل', url('/payroll/' . $this->payroll->id))
                    ->line('شكراً لاستخدامك نظام إدارة الموارد البشرية!');
    }

    public function toArray($notifiable)
    {
        return [
            'type' => 'payroll_created',
            'payroll_id' => $this->payroll->id,
            'employee_name' => $this->payroll->employee->name,
            'month' => $this->payroll->month->format('F Y'),
            'total_salary' => $this->payroll->total_salary,
            'message' => 'تم إنشاء قسيمة راتب جديدة لشهر ' . $this->payroll->month->format('F Y')
        ];
    }
}
