<?php

namespace App\Notifications;

use App\Models\Loan;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\DatabaseMessage;

class NewLoanRequestNotification extends Notification
{
    use Queueable;

    public $loan;

    public function __construct(Loan $loan)
    {
        $this->loan = $loan;
    }

    public function via($notifiable)
    {
        return ['database']; // نستخدم قاعدة البيانات فقط
    }

    public function toDatabase($notifiable)
    {
        return [
            'title_key' => 'notifications.new_loan_request_title',
            'title_params' => [],
            'message_key' => 'notifications.new_loan_request_message',
            'message_params' => [
                'employee' => $this->loan->employee->name,
                'employee_id' => $this->loan->employee->employee_id,
                'amount' => number_format($this->loan->amount, 2),
                'currency' => get_currency_code(),
            ],
            'url' => route('loans.show', $this->loan),
            'type' => 'new_loan_request',
            'loan_id' => $this->loan->id,
            'employee_id' => $this->loan->employee_id,
        ];
    }
}