<?php

namespace App\Notifications;

use App\Models\Loan;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class LoanApprovedNotification extends Notification
{
    use Queueable;

    public $loan;

    public function __construct(Loan $loan)
    {
        $this->loan = $loan;
    }

    public function via($notifiable)
    {
        return ['database']; // فقط قاعدة البيانات لتجنب استخدام الطابور
    }

    // دالة toMail غير معرفة لأن 'mail' غير موجود في via()

    public function toDatabase($notifiable)
    {
        return [
            'title_key' => 'notifications.loan_approved_title',
            'title_params' => [],
            'message_key' => 'notifications.loan_approved_message',
            'message_params' => ['loan_number' => $this->loan->loan_number],
            'url' => route('loans.show', $this->loan),
            'type' => 'loan_approved',
            'loan_id' => $this->loan->id,
        ];
    }
}