<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Messages\BroadcastMessage;

class AbsentReminderNotification extends Notification
{
    use Queueable;

    protected $date;
    protected $initiatorName;

    public function __construct($date = null, $initiatorName = null)
    {
        $this->date = $date ?: now()->toDateString();
        $this->initiatorName = $initiatorName;
    }

    public function via($notifiable)
    {
        // use database always; mail if user has email
        $channels = ['database'];
        if (!empty($notifiable->email)) {
            $channels[] = 'mail';
        }
        return $channels;
    }

    public function toMail($notifiable)
    {
        $url = url(route('employees.edit', [$notifiable->employee_id]));
        return (new MailMessage)
                    ->subject('تذكير بتسجيل الحضور')
                    ->greeting('مرحبًا ' . ($notifiable->name ?? ''))
                    ->line('هذا تذكير لتسجيل حضورك ليوم ' . $this->date)
                    ->action('تسجيل/تحديث الحضور', $url)
                    ->line('إذا قمت بالتسجيل بالفعل، فتجاهل هذه الرسالة.');
    }

    public function toArray($notifiable)
    {
        return [
            'title' => 'تذكير بتسجيل الحضور',
            'message' => 'هذا تذكير لتسجيل حضورك ليوم ' . $this->date,
            'link' => route('employees.edit', [$notifiable->employee_id]),
            'date' => $this->date,
            'initiator' => $this->initiatorName,
        ];
    }
}
