<?php // <-- يجب أن يكون هذا هو أول سطر في الملف بدون أي شيء قبله

namespace App\Models\Traits;

use Illuminate\Database\Eloquent\Builder;

trait TenantScoped
{
    /**
     * Boot the trait (يتم تنفيذه عند تحميل النموذج).
     */
    protected static function bootTenantScoped()
    {
        static::addGlobalScope('tenant', function (Builder $builder) {
            $tenantId = session('current_tenant_id'); // أو auth()->user()->tenant_id إذا كنت تستخدمه

            if ($tenantId) {
                // أضف شرط tenant_id إلى كل استعلام
                $builder->where('tenant_id', $tenantId);
            }
            // إذا لم يكن هناك tenant_id (مثلاً في لوحة التحكم الإداري)، يمكن السماح بعرض الكل
            // أو يمكن إضافة شرط آخر حسب الحاجة.
        });
    }

    /**
     * Scope لتجاوز الفلتر (مفيد فقط للإدارة المركزية).
     */
    public function scopeWithoutTenant(Builder $builder)
    {
        return $builder->withoutGlobalScope('tenant');
    }
}