<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TrainingEnrollment extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'training_enrollments';

    protected $fillable = [
        'program_id',
        'employee_id',
        'status',
        'progress_percentage',
        'score',
        'notes'
    ];

    protected $casts = [
        'progress_percentage' => 'integer',
        'score' => 'integer'
    ];

    // العلاقة مع البرنامج التدريبي
    public function program()
    {
        return $this->belongsTo(TrainingProgram::class, 'program_id');
    }

    // العلاقة مع الموظف
    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }

    // العلاقة مع سجل التقدم
    public function progressHistory()
    {
        return $this->hasMany(TrainingProgress::class, 'enrollment_id');
    }

    // نطاق للتسجيلات النشطة
    public function scopeActive($query)
    {
        return $query->whereIn('status', ['enrolled', 'in_progress']);
    }

    // نطاق للتسجيلات المكتملة
    public function scopeCompleted($query)
    {
        return $query->where('status', 'completed');
    }
}