<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalaryComponent extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'type', 'description'];

    // العلاقة مع جدول payroll_salary_components
    public function payrollComponents()
    {
        return $this->hasMany(PayrollSalaryComponent::class);
    }

    // ✅ إضافة العلاقة مع جدول employees عبر الجدول الوسيط employee_salary_components
    public function employees()
    {
        return $this->belongsToMany(Employee::class, 'employee_salary_components')
                    ->withPivot('value') // القيمة المخصصة لكل مكون لكل موظف
                    ->withTimestamps();   // created_at, updated_at للعلاقة
    }
}