<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'display_name',
        'description',
        'permissions', // json
    ];

    protected $casts = [
        'permissions' => 'array',
    ];

    // علاقة الدور مع الصلاحيات (pivot table role_permission)
    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'role_permission');
    }

    // علاقة الدور مع المستخدمين (Many-to-Many)
    public function users()
    {
        return $this->belongsToMany(User::class, 'user_role');
    }
}