<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Position extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'department_id',
    ];

    // المنصب تابع لقسم واحد
    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    // المنصب مرتبط بموظفين (اختياري لو عندك جدول employees)
    public function employees()
    {
        return $this->hasMany(Employee::class);
    }
}
