<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayrollSalaryComponent extends Model
{
    use HasFactory;

    protected $fillable = ['payroll_id', 'salary_component_id', 'value', 'meta', 'name'];

    protected $casts = [
        'meta' => 'array',
        'value' => 'decimal:2',
    ];

    // العلاقة مع جدول payrolls
    public function payroll()
    {
        return $this->belongsTo(Payroll::class);
    }

    // العلاقة مع جدول salary_components
    public function salaryComponent()
    {
        return $this->belongsTo(SalaryComponent::class);
    }
}