<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificationSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'email_enabled', 'whatsapp_enabled', 
        'telegram_enabled', 'whatsapp_number', 'telegram_chat_id', 'notification_types'
    ];

    protected $casts = [
        'email_enabled' => 'boolean',
        'whatsapp_enabled' => 'boolean',
        'telegram_enabled' => 'boolean',
        'notification_types' => 'array'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function canReceiveNotification($type)
    {
        if (!$this->notification_types) {
            return true; // افتراضياً تلقى جميع الإشعارات
        }
        
        return in_array($type, $this->notification_types);
    }
}
