<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LoanInstallment extends Model
{
    use HasFactory;

    protected $fillable = [
        'loan_id', 'installment_number', 'amount', 
        'due_date', 'paid_date', 'status', 'notes', 'payment_method'
    ];

    protected $casts = [
        'due_date' => 'date',
        'paid_date' => 'date',
        'amount' => 'decimal:2',
        'payment_method' => 'string', // إضافة تحويل لطريقة الدفع
    ];

    public function loan()
    {
        return $this->belongsTo(Loan::class);
    }

    /**
     * Mark this installment as paid.
     * @param string|null $paymentMethod The method used for payment (e.g., cash, bank_transfer).
     * @param string|null $notes Optional notes for the payment.
     * @return void
     */
    public function markAsPaid($paymentMethod = null, $notes = null)
    {
        $updateData = [
            'status' => 'paid',
            'paid_date' => now(),
        ];

        if ($paymentMethod) {
            $updateData['payment_method'] = $paymentMethod;
        }

        if ($notes !== null) { // يمكن أن تكون.notes فارغة، لذا نتحقق من null
            $updateData['notes'] = $notes;
        }

        $this->update($updateData);
        
        // التحقق من إكمال القرض بعد دفع هذا القسط
        $this->loan->updateIfCompleted();
    }

    public function markAsOverdue()
    {
        if ($this->status === 'pending' && $this->due_date < now()) {
            $this->update(['status' => 'overdue']);
        }
    }
}