<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeaveBalanceChange extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id', 'kind', 'days_change', 'effective_from', 'note', 'created_by'
    ];

    protected $casts = [
        'effective_from' => 'date',
        'days_change' => 'integer',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
