<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Holiday extends Model
{
    use HasFactory;

    protected $fillable = ['date', 'name', 'is_paid', 'holiday_year_id'];

    protected $casts = [
        'date' => 'date',
        'is_paid' => 'boolean',
    ];

    public function holidayYear()
    {
        return $this->belongsTo(HolidayYear::class);
    }
}
