<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeSalaryHistory extends Model
{
    use HasFactory;

    protected $table = 'employee_salary_histories';

    protected $fillable = [
        'employee_id',
        'effective_from',
        'base_salary',
        'incentives',
        'overtime_rate',
        'monthly_leave_entitlement',
        'annual_leave_entitlement',
        'components',
        'created_by',
        'note'
    ];

    protected $casts = [
        'effective_from' => 'date',
        'base_salary' => 'decimal:2',
        'incentives' => 'decimal:2',
        'overtime_rate' => 'decimal:4',
        'components' => 'array',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
