<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
    ];

    // قسم يحتوي على مناصب كثيرة
    public function positions()
    {
        return $this->hasMany(Position::class);
    }

    // قسم يحتوي على موظفين (اختياري لو عندك جدول employees)
    public function employees()
    {
        return $this->hasMany(Employee::class);
    }
}
