<?php

namespace App\Models;

use App\Scopes\CompanyScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Deduction extends Model
{
    use HasFactory;

    protected static function boot()
    {
        parent::boot();
        static::addGlobalScope(new CompanyScope());
    }

    protected $fillable = [
        'employee_id',
        'company_id',
        'type',
        'description',
        'amount',
        'deduction_date',
        'status',
        'is_monthly',
        'end_date',
        'notes',
        'frequency',
        'meta',
    ];

    /**
     * التحويلات التلقائية للحقول.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'deduction_date' => 'date', // تحويل إلى تاريخ
        'end_date' => 'date', // ✅ تحويل إلى تاريخ
        'amount' => 'decimal:2', // تحويل إلى رقم عشري بـ 2 خانات عشرية
        'is_monthly' => 'boolean', // ✅ تحويل إلى قيمة منطقية
        'meta' => 'array', // تحويل الحقل meta إلى مصفوفة تلقائياً
    ];

    /**
     * علاقة الاستقطاع بالموظف.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    // ✅ تم إزالة scopeActiveMonthly لأنه يعتمد على is_monthly (أو يمكن تحديثه ليعمل مع الحقول الجديدة إذا لازم)

    // ✅ تم إزالة العلاقات المعلّقة (installments, loan) علشان ما تلخبطش
    // /**
    //  * علاقة الاستقطاع بأقساطه (إذا كانت موجودة في project_dump.txt)
    //  * ✅ إضافة العلاقة إذا كانت موجودة في الجدول
    //  */
    // // public function installments()
    // // {
    // //     return $this->hasMany(LoanInstallment::class, 'loan_id'); // ✅ تأكد من اسم العلاقة والأعمدة
    // // }

    // /**
    //  * علاقة الاستقطاع بجدول الوسطاء (إذا كانت موجودة في project_dump.txt)
    //  * ✅ إضافة العلاقة إذا كانت موجودة في الجدول
    //  */
    // // public function loan()
    // // {
    // //     return $this->belongsTo(Loan::class, 'loan_id'); // ✅ تأكد من اسم العلاقة والأعمدة
    // // }
}
