<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AssetMaintenance extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'asset_id',
        'maintenance_date',
        'completed_date',
        'cost',
        'description',
        'status',
        'notes'
    ];

    protected $casts = [
        'cost' => 'decimal:2',
        'maintenance_date' => 'date',
        'completed_date' => 'date'
    ];

    protected $dates = [
        'maintenance_date',
        'completed_date',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    // العلاقة مع الأصل
    public function asset()
    {
        return $this->belongsTo(Asset::class, 'asset_id');
    }
}