<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AssetAssignment extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'asset_id',
        'employee_id',
        'assigned_at',
        'returned_at',
        'notes'
    ];

    protected $casts = [
        'assigned_at' => 'date',
        'returned_at' => 'date'
    ];

    protected $dates = [
        'assigned_at',
        'returned_at',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    // العلاقة مع الأصل
    public function asset()
    {
        return $this->belongsTo(Asset::class, 'asset_id');
    }

    // العلاقة مع الموظف
    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
}