<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Activity extends Model
{
    /**
     * الحقول القابلة للتعبئة.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'description',   // مثلاً 'login', 'created_user', 'updated_loan'
        'subject_type', // نوع الكيان المتأثر (User, Loan, Leave)
        'subject_id',   // معرف الكيان المتأثر
        'properties',   // بيانات إضافية (JSON)
    ];

    /**
     * تحويلات البيانات عند استرجاعها من قاعدة البيانات.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'properties' => 'array', // تحويل JSON إلى مصفوفة عند الاسترجاع
    ];

    /**
     * علاقة النشاط بالمستخدم الذي قام به.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * علاقة مرونة (Polymorphic) للربط بالكيان المتأثر.
     * يسمح بربط النشاط بـ Leave, User, Loan, إلخ.
     * يتطلب وجود عمودي subject_type و subject_id في جدول activities.
     */
    public function subject()
    {
        return $this->morphTo(); // ربط مرن بالكيان المتأثر
    }
}