<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'employee_id' => 'nullable|exists:employees,id',
            'roles' => 'required|array',
            'roles.*' => 'exists:roles,id'
        ];

        if ($this->isMethod('POST')) {
            $rules['password'] = ['required', 'confirmed', Password::defaults()];
        }

        if ($this->isMethod('PUT') || $this->isMethod('PATCH')) {
            $user = $this->route('user');
            $rules['email'] = 'required|string|email|max:255|unique:users,email,' . $user->id;
            $rules['password'] = 'nullable|confirmed|' . Password::defaults();
        }

        return $rules;
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'name.required' => 'الاسم مطلوب',
            'name.max' => 'الاسم يجب ألا يتجاوز 255 حرف',
            'email.required' => 'البريد الإلكتروني مطلوب',
            'email.email' => 'البريد الإلكتروني غير صحيح',
            'email.max' => 'البريد الإلكتروني يجب ألا يتجاوز 255 حرف',
            'email.unique' => 'البريد الإلكتروني مستخدم بالفعل',
            'employee_id.exists' => 'الموظف المحدد غير موجود',
            'password.required' => 'كلمة المرور مطلوبة',
            'password.confirmed' => 'تأكيد كلمة المرور غير متطابق',
            'roles.required' => 'الأدوار مطلوبة',
            'roles.array' => 'الأدوار يجب أن تكون مصفوفة',
            'roles.*.exists' => 'الأدوار المحددة غير صحيحة'
        ];
    }
}
