<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PayrollRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'employee_id' => 'required|exists:employees,id',
            'month'       => 'required|integer|min:1|max:12',
            'year'        => 'required|integer|min:2000|max:2100',
            'basic_salary' => 'required|numeric|min:0',
            'incentives'   => 'nullable|numeric|min:0', // ✅ تم تغيير 'allowances' إلى 'incentives'
            'status'       => 'required|in:pending,paid,cancelled',

            // مكونات الراتب الإضافية (حتى 7 مكونات)
            'salary_component_names'    => 'array|max:7',
            'salary_component_names.*'  => 'string|max:255|nullable',
            'salary_component_values'   => 'array|max:7',
            'salary_component_values.*' => 'required_with:salary_component_names.*|numeric|min:0',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        $currencyName = get_currency_code();

        return [
            'employee_id.required' => 'الموظف مطلوب.',
            'employee_id.exists'   => 'الموظف المحدد غير موجود.',
            'month.required'       => 'الشهر مطلوب.',
            'month.integer'        => 'الشهر يجب أن يكون رقماً صحيحاً بين 1 و 12.',
            'year.required'        => 'السنة مطلوبة.',
            'year.integer'         => 'السنة يجب أن تكون رقماً صحيحاً.',
            'basic_salary.required' => 'الراتب الأساسي مطلوب.',
            'basic_salary.numeric' => 'الراتب الأساسي يجب أن يكون رقماً.',
            'basic_salary.min'     => "الراتب الأساسي يجب أن يكون أكبر من أو يساوي صفر {$currencyName}.",

            // ✅ تم تغيير 'allowances' إلى 'incentives' في رسائل الخطأ
            'incentives.numeric' => 'الحوافز يجب أن تكون رقماً.',
            'incentives.min'     => "الحوافز يجب أن تكون أكبر من أو تساوي صفر {$currencyName}.",

            'status.required' => 'الحالة مطلوبة.',
            'status.in'       => 'الحالة يجب أن تكون واحدة من القيم المسموحة (قيد الدفع، مدفوع، ملغى).',

            // مكونات الراتب
            'salary_component_names.*.max' => 'اسم المكون لا يجب أن يتجاوز 255 حرفاً.',
            'salary_component_values.*.required_with' => 'القيمة مطلوبة إذا تم إدخال اسم مكون.',
            'salary_component_values.*.numeric' => 'قيمة المكون يجب أن تكون رقماً.',
        ];
    }
}