<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LoanRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'employee_id' => 'required|exists:employees,id',
            'title' => 'required|string|max:255',
            'description' => 'nullable|string|max:1000',
            'amount' => 'required|numeric|min:0',
            'interest_rate' => 'required|numeric|min:0|max:100',
            'installments_count' => 'required|integer|min:1|max:120',
            'start_date' => 'required|date'
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        // الحصول على رمز العملة الديناميكي (أحرف كبيرة)
        $currencyName = get_currency_code();

        return [
            'employee_id.required' => 'الموظف مطلوب',
            'employee_id.exists' => 'الموظف المحدد غير موجود',
            'title.required' => 'العنوان مطلوب',
            'title.max' => 'العنوان يجب ألا يتجاوز 255 حرف',
            'description.max' => 'الوصف يجب ألا يتجاوز 1000 حرف',
            'amount.required' => 'المبلغ مطلوب',
            'amount.numeric' => 'المبلغ يجب أن يكون رقماً',
            'amount.min' => "المبلغ يجب أن يكون أكبر من أو يساوي صفر {$currencyName}",
            'interest_rate.required' => 'نسبة الفائدة مطلوبة',
            'interest_rate.numeric' => 'نسبة الفائدة يجب أن تكون رقماً',
            'interest_rate.min' => 'نسبة الفائدة يجب أن تكون أكبر من أو تساوي صفر',
            'interest_rate.max' => 'نسبة الفائدة يجب ألا تتجاوز 100%',
            'installments_count.required' => 'عدد الأقساط مطلوب',
            'installments_count.integer' => 'عدد الأقساط يجب أن يكون رقماً صحيحاً',
            'installments_count.min' => 'عدد الأقساط يجب أن يكون أكبر من صفر',
            'installments_count.max' => 'عدد الأقساط يجب ألا يتجاوز 120',
            'start_date.required' => 'تاريخ البدء مطلوب',
            'start_date.date' => 'تاريخ البدء غير صحيح'
        ];
    }
}