<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DeductionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'employee_id' => 'required|exists:employees,id',
            // ✅ تحديث قيم type المسموحة لتكون شاملة
            'type' => 'required|in:tax,insurance,loan,fine,other,cash,in_kind,deduction,penalty,subscription,absence,cash_deduction,in_kind_deduction,taxes,social_insurance,health_insurance,penalties,deductions,loans,subscriptions,other_deductions',
            'description' => 'required|string|max:255',
            'amount' => 'required|numeric|min:0|max:100000', // ✅ إضافة max
            'deduction_date' => 'required|date',
            'is_monthly' => 'boolean',
            'end_date' => 'nullable|date|after:deduction_date',
            'notes' => 'nullable|string|max:1000'
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        // الحصول على رمز العملة الديناميكي (أحرف كبيرة)
        $currencyName = get_currency_code(); // تفترض وجود دالة مساعدة باسم get_currency_code()

        return [
            'employee_id.required' => 'الموظف مطلوب',
            'employee_id.exists' => 'الموظف المحدد غير موجود',
            'type.required' => 'نوع المسحوبات مطلوب',
            // ✅ تحديث رسالة الخطأ لـ type لتكون شاملة
            'type.in' => 'نوع المسحوبات المحدد غير صحيح. القيم المسموحة: tax, insurance, loan, fine, other, cash, in_kind, deduction, penalty, subscription, absence, cash_deduction, in_kind_deduction, taxes, social_insurance, health_insurance, penalties, deductions, loans, subscriptions, other_deductions.',
            'description.required' => 'الوصف مطلوب',
            'description.max' => 'الوصف يجب ألا يتجاوز 255 حرف',
            'amount.required' => 'المبلغ مطلوب',
            'amount.numeric' => 'المبلغ يجب أن يكون رقماً',
            'amount.min' => "المبلغ يجب أن يكون أكبر من أو يساوي صفر {$currencyName}",
            'amount.max' => "المبلغ لا يمكن أن يتجاوز 100,000 {$currencyName}", // ✅ إضافة رسالة max
            'deduction_date.required' => 'تاريخ المسحوبات مطلوب',
            'deduction_date.date' => 'تاريخ المسحوبات غير صحيح',
            'end_date.date' => 'تاريخ الانتهاء غير صحيح',
            'end_date.after' => 'تاريخ الانتهاء يجب أن يكون بعد تاريخ المسحوبات',
            'notes.max' => 'الملاحظات يجب ألا تتجاوز 1000 حرف'
        ];
    }
}