<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AttendanceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'employee_id' => 'required|exists:employees,id',
            'date' => 'required|date',
            'check_in' => 'nullable|date_format:H:i',
            'check_out' => 'nullable|date_format:H:i',
            'status' => 'required|in:present,absent,late,leave',
            'notes' => 'nullable|string|max:500'
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'employee_id.required' => 'الموظف مطلوب',
            'employee_id.exists' => 'الموظف المحدد غير موجود',
            'date.required' => 'التاريخ مطلوب',
            'date.date' => 'التاريخ غير صحيح',
            'check_in.date_format' => 'وقت الحضور يجب أن يكون بصيغة ساعة:دقيقة',
            'check_out.date_format' => 'وقت الانصراف يجب أن يكون بصيغة ساعة:دقيقة',
            'status.required' => 'الحالة مطلوبة',
            'status.in' => 'الحالة يجب أن تكون واحدة من القيم المسموحة',
            'notes.max' => 'الملاحظات يجب ألا تتجاوز 500 حرف'
        ];
    }
}
