<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;

class SetLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // الحصول على اللغة من الطلب أولاً، ثم من الجلسة، ثم استخدام العربية كافتراضي
        $locale = $request->get('locale') ?? Session::get('locale', 'ar');
        
        // التأكد من أن اللغة مدعومة
        if (!in_array($locale, ['ar', 'en', 'fr', 'es'])) {
            $locale = 'ar';
        }

        // تعيين اللغة في النظام
        App::setLocale($locale);
        
        // تخزين اللغة في الجلسة للطلبات المستقبلية
        Session::put('locale', $locale);

        // تعيين اتجاه النص (RTL/LTR) حسب اللغة
        $direction = ($locale === 'ar') ? 'rtl' : 'ltr';
        view()->share('direction', $direction);

        // تعيين لغة Carbon لعرض التواريخ باللغة الصحيحة
        Carbon::setLocale($locale);

        return $next($request);
    }
}