<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetActiveCompany
{
    /**
     * معالجة الطلب
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // إذا كان المستخدم مسجل دخول
        if (auth()->check()) {
            $user = auth()->user();
            
            // إذا كان super_admin، يمكنه اختيار شركة من الجلسة أو من الطلب
            if ($user->role === 'super_admin') {
                // تحقق من وجود company_id في الطلب (query parameter أو session)
                $companyId = $request->query('company_id') ?? session('active_company_id');
                
                if ($companyId) {
                    session(['active_company_id' => $companyId]);
                }
            } else {
                // المستخدمون العاديون يعملون مع شركتهم فقط
                session(['active_company_id' => $user->company_id]);
            }
        }

        return $next($request);
    }
}
