<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, $permission = null): Response
    {
        if (!Auth::check()) {
            return redirect('/login');
        }

        // إذا لم تُعط Middleware صلاحية محددة، اعتبر أن التحقق ناجح
        if ($permission === null) {
            return $next($request);
        }

        $user = Auth::user();

        // التحقق من الصلاحية المطلوبة فقط إذا تم تحديدها
        if (!$user->hasPermission($permission)) {
            abort(403, 'Access Denied');
        }

        return $next($request);
    }
}