<?php

namespace App\Http;

use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * Global middleware stack.
     * These middleware are run during every request.
     * (مترجم: مجموعة Middlewares العامة. هذه Middlewares تُنفذ مع كل طلب.)
     */
    protected $middleware = [
        \App\Http\Middleware\TrustProxies::class,
        \Illuminate\Http\Middleware\HandleCors::class,
        \App\Http\Middleware\PreventRequestsDuringMaintenance::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
    ];

    /**
     * Middleware groups.
     * (مترجم: مجموعات Middlewares.)
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            // لازم عشان flash messages & errors
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            // ✅ إضافة Middleware SetLocale لتفعيل اللغة في كل طلب ويب
            \App\Http\Middleware\SetLocale::class,
            // ✅ إضافة Middleware HandleTenant لتحديد المستأجر من subdomain
            \App\Http\Middleware\HandleTenant::class,
            // ✅ إضافة Middleware SetActiveCompany لتحديد الشركة النشطة
            \App\Http\Middleware\SetActiveCompany::class,
        ],
        'api' => [
            // ✅ التعديل المقترح: إضافة HandleTenant لضمان عزل بيانات API
            \App\Http\Middleware\HandleTenant::class, 
            // Sanctum (ممكن تفعلها لو بتستخدم SPA أو APIs محمية)
            // \Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful::class,
            'throttle:api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],
    ];

    /**
     * Route middleware.
     * يمكن استدعائها بالاسم في routes/web.php أو api.php
     * (مترجم: Middlewares الخاصة بالمسارات.
     *          يمكن استدعاؤها باستخدام الاسم في ملفات routes/web.php أو api.php)
     */
    protected $routeMiddleware = [
        'auth' => \App\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'auth.session' => \Illuminate\Auth\Middleware\AuthenticateSession::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class, // Middleware قياسي من Laravel للصلاحيات (Policy-based)
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'password.confirm' => \Illuminate\Auth\Middleware\RequirePassword::class,
        'signed' => \Illuminate\Routing\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,

        /**
         * Middleware مخصص للصلاحيات والأدوار الداخلية
         * (مترجم: Middleware مخصص للتحقق من الأدوار والصلاحيات الداخليّة)
         */
        'role' => \App\Http\Middleware\CheckRole::class,
        'permission' => \App\Http\Middleware\CheckPermission::class,
        'super_admin' => \App\Http\Middleware\SuperAdminMiddleware::class,
    ];
}