<?php

namespace App\Http\Controllers;

use App\Models\TrainingProgram;
use App\Models\Employee;
use Illuminate\Http\Request;

class TrainingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // عدد برامج التدريب
        $trainingsCount = TrainingProgram::count();
        
        // الموظفين
        $employees = Employee::orderBy('name')->get();
        
        // بما إنك لغيت نظام الصلاحيات، نخلي المدربين نفسهم الموظفين
        $trainers = $employees;
        
        // ✅ تم التصحيح: استخدام paginate() بدل get()
        $programs = TrainingProgram::orderBy('start_date', 'desc')->paginate(15);

        return view('training.index', compact('trainingsCount', 'employees', 'trainers', 'programs'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $employees = Employee::orderBy('name')->get();
        $trainers = $employees;
        return view('training.create', compact('employees', 'trainers'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'employee_id' => 'required|exists:employees,id',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
            'category' => 'nullable|string',
            'location' => 'nullable|string',
            'trainer_id' => 'nullable|exists:employees,id',
            'status' => 'nullable|string',
        ]);

        TrainingProgram::create($validated);

        return redirect()->route('training.index')->with('success', 'تم إنشاء البرنامج التدريبي بنجاح.');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(TrainingProgram $training)
    {
        $employees = Employee::orderBy('name')->get();
        $trainers = $employees;
        return view('training.edit', compact('training', 'employees', 'trainers'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, TrainingProgram $training)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'employee_id' => 'required|exists:employees,id',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
            'category' => 'nullable|string',
            'location' => 'nullable|string',
            'trainer_id' => 'nullable|exists:employees,id',
            'status' => 'nullable|string',
        ]);

        $training->update($validated);

        return redirect()->route('training.index')->with('success', 'تم تحديث البرنامج التدريبي بنجاح.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(TrainingProgram $training)
    {
        $training->delete();
        return redirect()->route('training.index')->with('success', 'تم حذف البرنامج التدريبي بنجاح.');
    }
}