<?php

// app/Http/Controllers/SettingController.php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Validation\Rule;

class SettingController extends Controller
{
    /**
     * عرض صفحة الإعدادات العامة (مثل العملة الافتراضية)
     */
    public function index()
    {
        // $this->authorize('manage_settings');

        $currentCurrency = get_currency_code();
        $availableCurrencies = $this->getCurrencyList(); // ← توحيد المصدر

        return view('settings.currency', compact('currentCurrency', 'availableCurrencies'));
    }

    /**
     * تحديث العملة الافتراضية
     */
    public function updateCurrency(Request $request)
    {
        // $this->authorize('manage_settings');

        $availableCurrencies = $this->getCurrencyList();
        $allowedCurrencies = array_keys($availableCurrencies);

        $rules = [
            'currency' => [
                'required',
                'string',
                Rule::in($allowedCurrencies), // ← أدق وأكثر أمانًا من 'in:...'
            ],
        ];

        $messages = [
            'currency.required' => 'يرجى اختيار العملة.',
            'currency.in'       => 'العملة المحددة غير مدعومة.',
        ];

        $request->validate($rules, $messages);

        // ✅ تحديث القيمة في قاعدة البيانات
        Setting::set('default_currency', $request->currency);

        // ✅ مسح الذاكرة المؤقتة فورًا (هذا السبب الأساسي لعدم التحديث في العرض!)
        Cache::forget('setting_default_currency');

        return redirect()->back()->with('success', '✅ تم تحديث العملة الافتراضية بنجاح.');
    }

    /**
     * دالة مساعدة: إرجاع مصفوفة ترابطية للعملات (رمز => اسم)
     * تُستخدم في العرض وفي التحقق — مصدر واحد للحقيقة.
     */
    private function getCurrencyList(): array
    {
        return [
            'EGP' => 'جنيه مصري (EGP)',
            'USD' => 'دولار أمريكي (USD)',
            'EUR' => 'يورو (EUR)',
            'GBP' => 'جنيه إسترليني (GBP)',
            'JPY' => 'ين ياباني (JPY)',
            'AUD' => 'دولار أسترالي (AUD)',
            'CAD' => 'دولار كندي (CAD)',
            'CHF' => 'فرنك سويسري (CHF)',
            'CNY' => 'يوان صيني (CNY)',
            'SEK' => 'كرونة سويدية (SEK)',
            'NOK' => 'كرونة نرويجية (NOK)',
            'DKK' => 'كرونة دانمركية (DKK)',
            'PLN' => 'زلوتي بولندي (PLN)',
            'INR' => 'روبية هندية (INR)',
            'BRL' => 'ريال برازيلي (BRL)',
            'MXN' => 'بيزو مكسيكي (MXN)',
            'ZAR' => 'راند جنوب أفريقي (ZAR)',
            'TRY' => 'ليرة تركية (TRY)',
            'RUB' => 'روبل روسي (RUB)',
            'KRW' => 'ون كوري جنوبي (KRW)',
            'SGD' => 'دولار سنغافوري (SGD)',
            'HKD' => 'دولار هونغ كونغ (HKD)',
            'NZD' => 'دولار نيوزيلندي (NZD)',
            'THB' => 'بات تايلاندي (THB)',
            'IDR' => 'روبية إندونيسية (IDR)',
            'MYR' => 'رينغيت ماليزي (MYR)',
            'PHP' => 'بيزو فلبيني (PHP)',
            'VND' => 'دونغ فيتنامي (VND)',
            'AED' => 'درهم إماراتي (AED)',
            'SAR' => 'ريال سعودي (SAR)',
            'KWD' => 'دينار كويتي (KWD)',
            'QAR' => 'ريال قطري (QAR)',
            'BHD' => 'دينار بحريني (BHD)',
            'OMR' => 'ريال عماني (OMR)',
            'JOD' => 'دينار أردني (JOD)',
            'ILS' => 'شيكل إسرائيلي (ILS)',
            'PKR' => 'روبية باكستانية (PKR)',
            'BDT' => 'تكا بنغلاديشية (BDT)',
            'LKR' => 'روبية سيلانكية (LKR)',
            'MAD' => 'درهم مغربي (MAD)',
            'TND' => 'دينار تونسي (TND)',
            'DZD' => 'دينار جزائري (DZD)',
            'LYD' => 'دينار ليبي (LYD)',
            'SDG' => 'جنيه سوداني (SDG)',
            'NGN' => 'نايرا نيجيري (NGN)',
            'GHS' => 'سيدي غاني (GHS)',
            'TZS' => 'شيلينغ تنزاني (TZS)',
            'KES' => 'شيلينغ كيني (KES)',
            'UGX' => 'شيلينغ أوغندي (UGX)',
            'ETB' => 'بير إثيوبي (ETB)',
            'AOA' => 'كوانزا أنغولي (AOA)',
            'ZMW' => 'كواشا زامبي (ZMW)',
            'MWK' => 'كواشا ملاوي (MWK)',
            'BWP' => 'بولا بوتسوانا (BWP)',
            'MUR' => 'روبية موريشيوسية (MUR)',
            'SCR' => 'روبية سيشلية (SCR)',
            'CVE' => 'إسكودو كابو فيريان (CVE)',
            'STN' => 'دوبرا ساو تومي وبرينسيبي (STN)',
            'GMD' => 'داﻻسي غامبي (GMD)',
            'GNF' => 'فرنك غيني (GNF)',
            'LRD' => 'دولار ليبيري (LRD)',
            'SLL' => 'ليون سيراليوني (SLL)',
            'CDF' => 'فرنك كونغولي (CDF)',
            'RWF' => 'فرنك رواندي (RWF)',
            'BIF' => 'فرنك بوروندي (BIF)',
            'DJF' => 'فرنك جيبوتي (DJF)',
            'SOS' => 'شيلينغ صومالي (SOS)',
            'KMF' => 'فرنك كوموري (KMF)',
            'MRU' => 'أوقية موريتانية (MRU)',
            'XAF' => 'فرنك CFA (BEAC) (XAF)',
            'XOF' => 'فرنك CFA (BCEAO) (XOF)',
            'XPF' => 'فرنك CFP (XPF)',
        ];
    }

    /**
     * عرض صفحة "اتصل بنا"
     */
    public function contact()
    {
        return view('contact');
    }
}