<?php

namespace App\Http\Controllers;

use App\Models\Position;
use App\Models\Department;
use Illuminate\Http\Request;

class PositionController extends Controller
{
    /**
     * عرض كل المناصب
     */
    public function index()
    {
        $positions = Position::with('department')->get();
        return view('positions.index', compact('positions'));
    }

    /**
     * عرض فورم إضافة منصب
     */
    public function create()
    {
        $departments = Department::all();
        return view('positions.create', compact('departments'));
    }

    /**
     * حفظ منصب جديد
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'          => 'required|string',
            'description'   => 'nullable|string',
            'department_id' => 'required|exists:departments,id',
        ]);

        Position::create($request->only('name', 'description', 'department_id'));

        return redirect()->back()->with('success', 'تم إضافة المنصب بنجاح');
    }

    /**
     * حذف منصب
     */
    public function destroy(Position $position)
    {
        $position->delete();
        return redirect()->back()->with('success', 'تم حذف المنصب بنجاح');
    }
}
