<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\App;

class LanguageController extends Controller
{
    /**
     * تغيير لغة التطبيق.
     *
     * @param string $locale رمز اللغة (ar, en, fr, es)
     * @return \Illuminate\Http\Response
     */
    public function switch($locale = null)
    {
        // إذا تم إرسال اللغة عبر النموذج (query parameter)
        if (request()->has('locale')) {
            $locale = request('locale');
        }
        // إذا لم يتم تحديد لغة، استخدم العربية كافتراضي
        if (empty($locale)) {
            $locale = 'ar';
        }

        // التحقق من أن اللغة مدعومة
        if (!in_array($locale, ['ar', 'en', 'fr', 'es'])) {
            // إذا كانت اللغة غير مدعومة، استخدم العربية كافتراضي
            $locale = 'ar';
        }

        // تعيين اللغة الحالية للتطبيق
        App::setLocale($locale);
        
        // تخزين اللغة في الجلسة (Session)
        Session::put('locale', $locale);
        
        // الحصول على عنوان URL للصفحة الحالية
        $previousUrl = url()->previous();
        
        // إذا كان الطلب من نموذج
        if (request()->isMethod('post') || request()->has('_token')) {
            return redirect($previousUrl)->with('success', __('app.language_changed'));
        }
        
        // التحقق مما إذا كان الطلب AJAX
        if (request()->ajax()) {
            return response()->json([
                'success' => true,
                'message' => __('app.language_changed'),
                'redirect' => $previousUrl
            ]);
        }

        // إعادة توجيه المستخدم إلى الصفحة السابقة
        return redirect()->back()->with('success', __('app.language_changed'));
    }
}