<?php

namespace App\Http\Controllers;

use App\Models\Department;
use Illuminate\Http\Request;

class DepartmentController extends Controller
{
    /**
     * عرض كل الأقسام
     */
    public function index()
    {
        $departments = Department::all();
        return view('departments.index', compact('departments'));
    }

    /**
     * عرض فورم إضافة قسم
     */
    public function create()
    {
        return view('departments.create');
    }

    /**
     * حفظ قسم جديد
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:departments,name',
            'description' => 'nullable|string',
        ]);

        Department::create($request->only('name', 'description'));

        return redirect()->back()->with('success', 'تم إضافة القسم بنجاح');
    }

    /**
     * حذف قسم
     */
    public function destroy(Department $department)
    {
        $department->delete();
        return redirect()->back()->with('success', 'تم حذف القسم بنجاح');
    }
}
