<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Permission;

class PermissionReportController extends Controller
{
    public function index()
    {
        // Paginate users to keep the page usable
        $users = User::with(['roles.permissions','permissionsRel','deniedPermissions'])->paginate(50);

        $permissions = Permission::orderBy('name')->get();

        // Normalize relations and build effective-permission map for each user (small summary)
        $report = [];
        foreach ($users as $user) {
            $user->roles = collect($user->roles ?? []);
            foreach ($user->roles as $role) {
                if (is_object($role)) $role->permissions = collect($role->permissions ?? []);
                else $role['permissions'] = collect($role['permissions'] ?? []);
            }
            $user->permissionsRel = collect($user->permissionsRel ?? []);
            $user->deniedPermissions = collect($user->deniedPermissions ?? []);

            // now compute
            
            $perms = [];
            foreach ($permissions as $perm) {
                // denied explicit
                if (collect($user->deniedPermissions)->pluck('id')->contains($perm->id)) {
                    $perms[] = ['perm' => $perm->name, 'status' => 'Denied explicitly'];
                    continue;
                }
                // allowed explicit
                if (collect($user->permissionsRel)->pluck('id')->contains($perm->id)) {
                    $perms[] = ['perm' => $perm->name, 'status' => 'Allowed explicitly'];
                    continue;
                }
                // via role
                $via = null;
                foreach ($user->roles as $r) {
                    $rolePerms = collect($r->permissions);
                    // normalize to ids then check
                    $rolePermIds = $rolePerms->pluck('id')->filter()->toArray();
                    if (in_array($perm->id, $rolePermIds, true)) { $via = is_object($r) ? ($r->name ?? null) : ($r['name'] ?? null); break; }
                }
                if ($via) {
                    $perms[] = ['perm' => $perm->name, 'status' => "Granted via role {$via}"];
                } else {
                    $perms[] = ['perm' => $perm->name, 'status' => 'Not granted'];
                }
            }
            $report[] = ['user' => $user, 'permissions' => $perms];
        }

        return view('admin.permission_report', compact('users','permissions','report'));
    }
}
