<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;

class UserCheck extends Command
{
    protected $signature = 'user:check {email}';
    protected $description = 'عرض الأدوار والصلاحيات لمستخدم معين';

    public function handle()
    {
        $email = $this->argument('email');
        $user = User::where('email', $email)->first();

        if (!$user) {
            $this->error('المستخدم غير موجود');
            return 1;
        }

        $this->info("المستخدم: {$user->name} ({$user->email})");
        $this->info("الأدوار: " . implode(', ', $user->roles->pluck('name')->toArray()));
        $this->info("صلاحية إدارة الإجازات: " . ($user->can('manage_leaves') ? 'نعم' : 'لا'));
        $this->info("أي دور admin/super-admin: " . ($user->hasRole(['admin','super-admin']) ? 'نعم' : 'لا'));
        return 0;
    }
}
