<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Throwable;

class RunFlagTests extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'dev:flag-tests';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run small checks for accrue_leaves, deduct_if_underworked and overtime_paid flags and print JSON results';

    public function handle()
    {
        $out = [];
        try {
            $e = \App\Models\Employee::first();
            if (! $e) {
                $e = \App\Models\Employee::create([
                    'name' => 'auto-test',
                    'status' => 'active',
                    'hire_date' => '2025-01-01',
                    'salary' => 1500,
                    'monthly_leave_days_allowed' => 1,
                    'overtime_hourly_rate' => 10,
                ]);
            }
            $out['employee_id'] = $e->id;

            // --- accrue_leaves test ---
            $e->accrue_leaves = false;
            $e->save();
            $out['accrue_is_enabled'] = $e->isAccrualEnabled();
            $out['balance_when_accrue_disabled'] = $e->getLeaveBalanceAtEndOfMonthNew(2025, 11);

            // --- deduct_if_underworked test ---
            $lt = \App\Models\LeaveType::where('code', 'annual')->first();
            if (! $lt) {
                $lt = \App\Models\LeaveType::create(['name' => 'Annual', 'code' => 'annual']);
            }
            // create an approved leave of 3 days in Nov 2025
            $l = \App\Models\Leave::create([
                'employee_id' => $e->id,
                'leave_type_id' => $lt->id,
                'start_date' => '2025-11-01',
                'end_date' => '2025-11-03',
                'status' => 'approved',
                'days_count' => 3,
                'reason' => 'auto test',
            ]);

            $e->deduct_if_underworked = false; $e->save();
            $out['deduct_disabled_value'] = \App\Models\Employee::find($e->id)->calculateLeaveDeductionForMonth(2025, 11);

            $e->deduct_if_underworked = true; $e->save();
            $out['deduct_enabled_value'] = \App\Models\Employee::find($e->id)->calculateLeaveDeductionForMonth(2025, 11);

            // --- overtime_paid test ---
            $a = \App\Models\Attendance::create([
                'employee_id' => $e->id,
                'date' => '2025-11-10',
                'check_in' => '09:00:00',
                'check_out' => '19:00:00',
            ]);

            $e->overtime_paid = false; $e->save();
            $e->recalcOvertimeTotals();
            $out['overtime_disabled_pay_total'] = $e->overtime_pay_total;

            $e->overtime_paid = true; $e->save();
            $e->recalcOvertimeTotals();
            $out['overtime_enabled_pay_total'] = $e->overtime_pay_total;

            $this->line(json_encode($out, JSON_UNESCAPED_UNICODE));
            return 0;
        } catch (Throwable $ex) {
            $this->error('Error: ' . $ex->getMessage());
            $this->line(json_encode(['error' => $ex->getMessage()], JSON_UNESCAPED_UNICODE));
            return 1;
        }
    }
}
