<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class FixMissingAttendancePermissions extends Command
{
    protected $signature = 'permissions:fix-attendance';
    protected $description = 'إصلاح صلاحيات الحضور المفقودة';

    public function handle()
    {
        $this->info('جاري إصلاح صلاحيات الحضور المفقودة...');

        // قائمة صلاحيات الحضور المطلوبة
        $attendancePermissions = [
            'view attendance',
            'create attendance',
            'edit attendance',
            'delete attendance',
            'manage-attendance',
            'approve attendance',
            'reject attendance',
            'export attendance',
            'import attendance'
        ];

        $createdCount = 0;
        $existingCount = 0;

        // إنشاء الصلاحيات المفقودة
        foreach ($attendancePermissions as $permissionName) {
            $permission = Permission::firstOrCreate([
                'name' => $permissionName,
                'guard_name' => 'web'
            ], [
                'name' => $permissionName,
                'guard_name' => 'web'
            ]);

            if ($permission->wasRecentlyCreated) {
                $createdCount++;
                $this->line("✓ تم إنشاء الصلاحية: {$permission->name}");
            } else {
                $existingCount++;
                $this->line("• الصلاحية موجودة: {$permission->name}");
            }
        }

        // ربط الصلاحيات بالأدوار
        $roles = ['superadmin', 'admin', 'hr'];
        foreach ($roles as $roleName) {
            $role = Role::where('name', $roleName)->first();
            if ($role) {
                $role->givePermissionTo($attendancePermissions);
                $this->info("✓ تم ربط صلاحيات الحضور بالدور: {$roleName}");
            } else {
                $this->warn("⚠ الدور غير موجود: {$roleName}");
            }
        }

        $this->info("\n✅ تم الإنتهاء!");
        $this->info("✓ الصلاحيات المنشأة: {$createdCount}");
        $this->info("• الصلاحيات الموجودة: {$existingCount}");

        return 0;
    }
}