<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;

class ExportDeniedPermissions extends Command
{
    protected $signature = 'permissions:export-denied {--path=storage/app/}';
    protected $description = 'Export user_permission_denied to CSV in storage/app (timestamped)';

    public function handle()
    {
        $ts = Carbon::now()->format('Ymd_His');
        $filename = "denied_permissions_{$ts}.csv";
        $path = trim($this->option('path'), '\\/') . DIRECTORY_SEPARATOR . $filename;

        $rows = DB::table('user_permission_denied')
            ->join('users', 'user_permission_denied.user_id', '=', 'users.id')
            ->join('permissions', 'user_permission_denied.permission_id', '=', 'permissions.id')
            ->select('users.id as user_id', 'users.email as user_email', 'permissions.id as permission_id', 'permissions.name as permission_name')
            ->orderBy('users.id')
            ->get();

        $csv = fopen(storage_path('app' . DIRECTORY_SEPARATOR . $filename), 'w');
        fputcsv($csv, ['user_id','user_email','permission_id','permission_name']);
        foreach ($rows as $r) {
            fputcsv($csv, [(int)$r->user_id, $r->user_email, (int)$r->permission_id, $r->permission_name]);
        }
        fclose($csv);

        $this->info("Exported " . count($rows) . " rows to storage/app/{$filename}");
        return 0;
    }
}
