<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Attendance;

class BackfillAttendanceLeaveId extends Command
{
    protected $signature = 'attendance:backfill-leaveid {--dry-run}';
    protected $description = 'Backfill attendances that are missing leave_id when an approved leave covers the attendance date.';

    public function handle()
    {
        $dry = $this->option('dry-run');

        $this->info('Scanning attendances missing leave_id...');

        $query = Attendance::whereNull('leave_id');
        $total = $query->count();
        $this->info("Found {$total} attendances without leave_id.");

        $bar = $this->output->createProgressBar($total);
        $bar->start();

        $updated = 0;

        $query->chunk(200, function($rows) use (&$updated, $dry, $bar) {
            foreach ($rows as $att) {
                $d = $att->date instanceof \Carbon\Carbon ? $att->date->toDateString() : (string) $att->date;
                $lv = \App\Models\Leave::where('employee_id', $att->employee_id)
                    ->where('status', 'approved')
                    ->whereDate('start_date', '<=', $d)
                    ->whereDate('end_date', '>=', $d)
                    ->orderBy('id', 'desc')
                    ->first();

                if ($lv) {
                    if (!$dry) {
                        $att->leave_id = $lv->id;
                        $att->save();
                    }
                    $updated++;
                }
                $bar->advance();
            }
        });

        $bar->finish();
        $this->line('');
        $this->info("Completed. Attendances matched: {$updated}. Dry-run: " . ($dry ? 'yes' : 'no'));
        return 0;
    }
}
