## خطوات الترحيل والاختبار لنظام الإجازات الجديد

هذه الملاحظات موجزة لتشغيل التعديلات التي أضفتها محليًا على بيئتك (Windows, PowerShell).

1) حفظ نسخة احتياطية من قاعدة البيانات (قم بعمل dump قبل أي ترحيل).

2) تشغيل الميجريشنز وملء أنواع الإجازات:

```powershell
# من مجلد المشروع
php artisan migrate
php artisan db:seed --class="Database\\Seeders\\LeaveTypesSeeder"
```

3) تشغيل الاختبارات:

```powershell
php artisan test
# أو
vendor\\bin\\phpunit
```

4) خطوات تحقق سريعة بعد التشغيل:
- افتح صفحة الموظفين وأنشئ موظفًا مع `annual_entitlement` و `weekly_off_days`.
- قدّم طلب إجازة نوع `annual` ثم وافق عليه من خلال لوحة الإدارة؛ تفقد جدول `leave_balance_changes` وعمود `balance_snapshot` في سجل الإجازة.
- أنشئ إجازة `unpaid` مع اعتماد `approved_at` داخل نفس شهر الرواتب، ثم شغّل توليد الرواتب الشهري (`generate monthly`) وتأكد من ظهور مكون سلبي باسم "خصم إجازة بدون راتب" في مكونات الراتب.

ملاحظات تقنية:
- الدوال التي أضفتها تعتمد على الحقول: `employees.annual_entitlement`, `employees.weekly_off_days` (json array), `leave_types`, `leave_balance_changes`, `holidays`, وتوسيع `leaves` ليشمل `leave_type_id`, `deducted_days`, `balance_snapshot`.
- احتفظت بحقل النص `leave_type` للتوافق الخلفي.

إذا واجهت أي خطأ عند تشغيل `php artisan migrate`، أرسل رسالة الخطأ وسأصلحه فورًا.
