# دليل نظام التعددية (Multi-Tenancy) - لوحة تحكم السوبر أدمن

## 📋 نظرة عامة

تم تطوير نظام متقدم لإدارة عدة شركات من لوحة تحكم مركزية واحدة مع عزل تام للبيانات بين الشركات.

---

## 🏗️ معمارية النظام

### 1. **قاعدة البيانات**
- جدول `companies`: يحتوي على بيانات الشركات
- جميع الجداول الأخرى تحتوي على عمود `company_id` للربط مع الشركة

### 2. **الموديلات**
```
Company (الشركة الأم)
├── Users (المستخدمون)
├── Employees (الموظفون)
├── Payrolls (الرواتب)
├── Loans (القروض)
├── Deductions (الاستقطاعات)
├── Leaves (الإجازات)
├── Attendances (الحضور)
└── Branches (الفروع)
```

### 3. **Global Scope (CompanyScope)**
- يتم تطبيق `CompanyScope` على جميع الموديلات
- يقيد الاستعلامات تلقائياً لعرض فقط بيانات الشركة الحالية
- يسمح للـ `super_admin` بتجاوز القيد

---

## 🔐 الأدوار والصلاحيات

### الأدوار المتاحة:

| الدور | الصلاحيات |
|------|---------|
| **super_admin** | إدارة جميع الشركات والمستخدمين، محاكاة الدخول |
| **admin** | إدارة موظفي الشركة والرواتب والقروض |
| **manager** | إدارة الموظفين والحضور والإجازات |
| **employee** | عرض بيانات شخصية فقط |

---

## 🚀 كيفية الاستخدام

### 1. **الدخول إلى لوحة السوبر أدمن**

```
URL: /super-admin/dashboard
البريد الإلكتروني: superadmin@example.com
كلمة المرور: password
```

### 2. **إنشاء شركة جديدة**

```
1. اذهب إلى: /super-admin/companies
2. انقر على "إضافة شركة جديدة"
3. أدخل بيانات الشركة
4. انقر على "حفظ"
```

### 3. **إضافة مستخدم للشركة**

```
1. اختر الشركة من قائمة الشركات
2. انقر على "المستخدمون"
3. انقر على "إضافة مستخدم جديد"
4. أدخل بيانات المستخدم واختر الدور
5. انقر على "حفظ"
```

### 4. **محاكاة دخول مستخدم (Impersonation)**

```
1. اذهب إلى قائمة مستخدمي الشركة
2. انقر على زر "محاكاة الدخول" (أيقونة تسجيل الدخول)
3. سيتم تسجيل دخولك كهذا المستخدم
4. لإنهاء المحاكاة: انقر على "إنهاء محاكاة الدخول" من القائمة
```

---

## 📊 المسارات (Routes)

### لوحة السوبر أدمن:

```
GET    /super-admin/dashboard                          # لوحة التحكم الرئيسية
GET    /super-admin/companies                          # قائمة الشركات
GET    /super-admin/companies/create                   # نموذج إنشاء شركة
POST   /super-admin/companies                          # حفظ شركة جديدة
GET    /super-admin/companies/{company}/edit           # نموذج تعديل شركة
PUT    /super-admin/companies/{company}                # تحديث الشركة
DELETE /super-admin/companies/{company}                # حذف الشركة

GET    /super-admin/companies/{company}/users          # قائمة مستخدمي الشركة
GET    /super-admin/companies/{company}/users/create   # نموذج إنشاء مستخدم
POST   /super-admin/companies/{company}/users          # حفظ مستخدم جديد
GET    /super-admin/companies/{company}/users/{user}/edit  # نموذج تعديل مستخدم
PUT    /super-admin/companies/{company}/users/{user}   # تحديث المستخدم
DELETE /super-admin/companies/{company}/users/{user}   # حذف المستخدم
POST   /super-admin/companies/{company}/users/{user}/impersonate  # محاكاة الدخول

POST   /super-admin/stop-impersonation                 # إنهاء محاكاة الدخول
```

---

## 🔒 العزل والأمان

### CompanyScope:
```php
// يتم تطبيق هذا تلقائياً على جميع الاستعلامات
Employee::all(); // يعيد فقط موظفي الشركة الحالية

// السوبر أدمن يمكنه تجاوز القيد
auth()->user()->role === 'super_admin' // يرى جميع البيانات
```

### Middleware:
```php
// حماية مسارات السوبر أدمن
Route::middleware(['auth', 'super_admin'])->group(function () {
    // فقط super_admin يمكنه الوصول
});
```

### Policy:
```php
// التحقق من الصلاحيات
$this->authorize('update', $company); // فقط super_admin
```

---

## 📝 Logging والتدقيق

### جميع إجراءات السوبر أدمن يتم تسجيلها:

```
- إنشاء/تحديث/حذف شركة
- إنشاء/تحديث/حذف مستخدم
- محاكاة الدخول
- إنهاء محاكاة الدخول
```

### موقع السجلات:
```
storage/logs/super_admin.log
```

### مثال على السجل:
```json
{
  "timestamp": "2025-12-07T04:14:00Z",
  "super_admin_id": 1,
  "super_admin_email": "superadmin@example.com",
  "action": "CREATE",
  "model": "Company",
  "model_id": 5,
  "ip_address": "192.168.1.1",
  "user_agent": "Mozilla/5.0...",
  "data": {
    "name": "شركة جديدة",
    "email": "new@company.com",
    "status": "active"
  }
}
```

---

## 🧪 الاختبارات

### تشغيل اختبارات العزل:

```bash
php artisan test tests/Feature/CompanyIsolationTest.php
```

### الاختبارات المتاحة:

1. **test_user_cannot_see_employees_from_other_company**
   - التحقق من أن المستخدم لا يرى موظفي شركة أخرى

2. **test_companies_have_isolated_data**
   - التحقق من أن كل شركة لها بيانات منفصلة

3. **test_super_admin_can_see_all_companies**
   - التحقق من أن السوبر أدمن يرى جميع الشركات

4. **test_user_cannot_access_other_company_data_via_query**
   - التحقق من أن المستخدم لا يستطيع الوصول إلى بيانات شركة أخرى

5. **test_scope_works_with_relationships**
   - التحقق من أن الـ scope يعمل مع العلاقات

---

## 🔧 التثبيت والإعداد

### 1. تشغيل الـ Migrations:
```bash
php artisan migrate
```

### 2. تشغيل الـ Seeder:
```bash
php artisan db:seed --class=SuperAdminSeeder
```

### 3. الحسابات الافتراضية:
```
Super Admin:
  البريد: superadmin@example.com
  كلمة المرور: password

Admin:
  البريد: admin@example.com
  كلمة المرور: password
```

---

## 📁 هيكل الملفات

```
app/
├── Http/
│   ├── Controllers/
│   │   └── SuperAdminController.php
│   └── Middleware/
│       ├── SetActiveCompany.php
│       └── SuperAdminMiddleware.php
├── Models/
│   ├── Company.php
│   ├── User.php (محدث)
│   ├── Employee.php (محدث)
│   ├── Payroll.php (محدث)
│   ├── Loan.php (محدث)
│   ├── Deduction.php (محدث)
│   ├── Leave.php (محدث)
│   └── Attendance.php (محدث)
├── Policies/
│   └── CompanyPolicy.php
├── Scopes/
│   └── CompanyScope.php
└── Services/
    └── SuperAdminAuditLog.php

database/
├── migrations/
│   ├── 2025_12_07_045834_create_companies_table.php
│   ├── 2025_12_07_045851_add_company_id_to_users_table.php
│   └── 2025_12_07_045906_add_company_id_to_core_tables.php
└── seeders/
    └── SuperAdminSeeder.php

resources/views/super-admin/
├── dashboard.blade.php
├── companies/
│   ├── index.blade.php
│   ├── create.blade.php
│   └── edit.blade.php
└── users/
    ├── index.blade.php
    ├── create.blade.php
    └── edit.blade.php

tests/Feature/
└── CompanyIsolationTest.php
```

---

## ⚠️ ملاحظات مهمة

1. **الأمان**: تأكد من تغيير كلمات المرور الافتراضية فوراً
2. **النسخ الاحتياطية**: قم بعمل نسخ احتياطية منتظمة لقاعدة البيانات
3. **السجلات**: راقب ملفات السجلات بانتظام للكشف عن أي نشاط مريب
4. **الصيانة**: قم بتنظيف السجلات القديمة بشكل دوري

---

## 🆘 استكشاف الأخطاء

### المشكلة: المستخدم يرى بيانات شركة أخرى

**الحل**: تأكد من أن `company_id` محفوظ بشكل صحيح في جلسة المستخدم

### المشكلة: لا يمكن الدخول إلى لوحة السوبر أدمن

**الحل**: تأكد من أن المستخدم لديه `role = 'super_admin'`

### المشكلة: الـ Scope لا يعمل

**الحل**: تأكد من تطبيق `addGlobalScope(new CompanyScope())` في `boot()` method

---

## 📞 الدعم

للمساعدة أو الإبلاغ عن مشاكل، يرجى التواصل مع فريق التطوير.

---

**آخر تحديث**: 7 ديسمبر 2025
**الإصدار**: 1.0.0
