# 📦 دليل التثبيت والإعداد - نظام إدارة الموارد البشرية

## المتطلبات

- PHP 8.1+
- Laravel 10+
- MySQL 5.7+
- Composer

---

## 🔧 خطوات التثبيت

### 1. استنساخ المشروع
```bash
git clone <repository-url>
cd hr
```

### 2. تثبيت المكتبات
```bash
composer install
```

### 3. إنشاء ملف البيئة
```bash
cp .env.example .env
```

### 4. إنشاء مفتاح التطبيق
```bash
php artisan key:generate
```

### 5. إعداد قاعدة البيانات

#### في ملف `.env`:
```
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=hr_system
DB_USERNAME=root
DB_PASSWORD=
```

#### إنشاء قاعدة البيانات:
```bash
mysql -u root -p
CREATE DATABASE hr_system;
EXIT;
```

### 6. تشغيل الـ Migrations
```bash
php artisan migrate
```

### 7. تشغيل الـ Seeders
```bash
php artisan db:seed --class=SuperAdminSeeder
```

### 8. إنشاء رابط التخزين
```bash
php artisan storage:link
```

### 9. تشغيل الخادم
```bash
php artisan serve
```

---

## 🔑 الحسابات الافتراضية

### Super Admin:
```
البريد الإلكتروني: superadmin@example.com
كلمة المرور: password
الرابط: http://localhost:8000/super-admin/dashboard
```

### Admin:
```
البريد الإلكتروني: admin@example.com
كلمة المرور: password
الشركة: الشركة الرئيسية
```

---

## ⚙️ الإعدادات الإضافية

### 1. إعداد البريد الإلكتروني (اختياري)

في ملف `.env`:
```
MAIL_MAILER=smtp
MAIL_HOST=smtp.mailtrap.io
MAIL_PORT=465
MAIL_USERNAME=your_username
MAIL_PASSWORD=your_password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@example.com
```

### 2. إعداد التخزين السحابي (اختياري)

في ملف `.env`:
```
FILESYSTEM_DISK=s3
AWS_ACCESS_KEY_ID=your_key
AWS_SECRET_ACCESS_KEY=your_secret
AWS_DEFAULT_REGION=us-east-1
AWS_BUCKET=your_bucket
```

### 3. إعداد الـ Logging

في ملف `config/logging.php`:
```php
'super_admin' => [
    'driver' => 'single',
    'path' => storage_path('logs/super_admin.log'),
    'level' => 'info',
],
```

---

## 🧪 تشغيل الاختبارات

### تشغيل جميع الاختبارات:
```bash
php artisan test
```

### تشغيل اختبارات العزل فقط:
```bash
php artisan test tests/Feature/CompanyIsolationTest.php
```

### تشغيل اختبار محدد:
```bash
php artisan test tests/Feature/CompanyIsolationTest.php --filter=test_user_cannot_see_employees_from_other_company
```

---

## 📊 هيكل المشروع

```
hr/
├── app/
│   ├── Http/
│   │   ├── Controllers/
│   │   │   └── SuperAdminController.php
│   │   └── Middleware/
│   │       ├── SetActiveCompany.php
│   │       └── SuperAdminMiddleware.php
│   ├── Models/
│   │   ├── Company.php
│   │   ├── User.php
│   │   ├── Employee.php
│   │   └── ...
│   ├── Policies/
│   │   └── CompanyPolicy.php
│   ├── Scopes/
│   │   └── CompanyScope.php
│   └── Services/
│       └── SuperAdminAuditLog.php
├── database/
│   ├── migrations/
│   └── seeders/
│       └── SuperAdminSeeder.php
├── resources/
│   └── views/
│       └── super-admin/
├── routes/
│   └── web.php
├── tests/
│   └── Feature/
│       └── CompanyIsolationTest.php
├── storage/
│   └── logs/
│       └── super_admin.log
├── .env
├── .env.example
├── MULTI_TENANCY_GUIDE.md
├── SUPER_ADMIN_SUMMARY.md
└── INSTALLATION.md
```

---

## 🚀 نصائح الإنتاج

### 1. تحسين الأداء
```bash
# تجميع الإعدادات
php artisan config:cache

# تجميع المسارات
php artisan route:cache

# تجميع الـ Views
php artisan view:cache
```

### 2. الأمان
```bash
# تغيير مفتاح التطبيق
php artisan key:generate

# تحديث كلمات المرور الافتراضية
# اذهب إلى /super-admin/dashboard وغيّر كلمات المرور
```

### 3. النسخ الاحتياطية
```bash
# إنشاء نسخة احتياطية من قاعدة البيانات
mysqldump -u root -p hr_system > backup.sql

# استعادة النسخة الاحتياطية
mysql -u root -p hr_system < backup.sql
```

### 4. المراقبة
```bash
# مراقبة السجلات
tail -f storage/logs/super_admin.log

# مراقبة السجلات الأخرى
tail -f storage/logs/laravel.log
```

---

## 🔍 استكشاف الأخطاء

### مشكلة: "SQLSTATE[HY000]: General error"

**الحل**:
```bash
php artisan migrate:fresh
php artisan db:seed --class=SuperAdminSeeder
```

### مشكلة: "Class 'App\Models\Company' not found"

**الحل**:
```bash
composer dump-autoload
php artisan cache:clear
```

### مشكلة: "Permission denied" عند الكتابة في storage

**الحل**:
```bash
chmod -R 775 storage
chmod -R 775 bootstrap/cache
```

### مشكلة: "CORS error" عند الطلبات

**الحل**: تحقق من إعدادات CORS في `config/cors.php`

---

## 📚 الموارد الإضافية

- [دليل Laravel الرسمي](https://laravel.com/docs)
- [دليل MySQL](https://dev.mysql.com/doc/)
- [دليل Composer](https://getcomposer.org/doc/)

---

## 🆘 الدعم

للمساعدة أو الإبلاغ عن مشاكل:
1. تحقق من الملفات المرجعية
2. راجع السجلات في `storage/logs/`
3. تواصل مع فريق التطوير

---

## 📝 ملاحظات مهمة

⚠️ **تغيير كلمات المرور الافتراضية فوراً بعد التثبيت**

⚠️ **تفعيل HTTPS في الإنتاج**

⚠️ **عمل نسخ احتياطية منتظمة**

⚠️ **مراقبة السجلات بانتظام**

---

**تاريخ آخر تحديث**: 7 ديسمبر 2025
