# 📊 دليل شامل: سجلات التعويض (Compensation Records)

## 🎯 ما هي سجلات التعويض؟

**سجلات التعويض** (Employee Salary History) هي نظام لتتبع **تاريخ تغييرات الراتب** للموظف مع **تواريخ فعالة** (Effective Dates). هذا النظام يسمح لك بتسجيل تغييرات الراتب عبر الزمن والحفاظ على دقة الحسابات التاريخية.

---

## 📋 المكونات الأساسية

### 1. **الجدول في قاعدة البيانات**
- **اسم الجدول**: `employee_salary_histories`
- **العلاقة**: كل سجل مرتبط بموظف واحد (`employee_id`)

### 2. **الحقول الرئيسية**

| الحقل | النوع | الوصف |
|------|------|-------|
| `employee_id` | Foreign Key | معرف الموظف |
| `effective_from` | Date | **تاريخ بدء التطبيق** (التاريخ الفعلي) |
| `base_salary` | Decimal | الراتب الأساسي |
| `incentives` | Decimal | الحوافز |
| `overtime_rate` | Decimal | معدل ساعة العمل الإضافي |
| `monthly_leave_entitlement` | Integer | الحصة الشهرية من الإجازات |
| `annual_leave_entitlement` | Integer | الحصة السنوية من الإجازات |
| `components` | JSON | مكونات الراتب الإضافية (مصفوفة) |
| `created_by` | Foreign Key | المستخدم الذي أنشأ السجل |
| `note` | Text | ملاحظات |

---

## 🔍 كيف يعمل النظام؟

### **المبدأ الأساسي: Effective Date (التاريخ الفعلي)**

النظام يعمل على مبدأ **"التاريخ الفعلي"**:
- كل سجل تعويض له `effective_from` (تاريخ بدء التطبيق)
- عند حساب الراتب لشهر معين، النظام يبحث عن **أحدث سجل** حيث `effective_from <= تاريخ الشهر`
- هذا يعني أن السجل الأحدث (الأقرب للتاريخ المطلوب) هو الذي يُستخدم

### **مثال عملي:**

```
الموظف: أحمد محمد
تاريخ التعيين: 2024-01-01

سجلات التعويض:
1. 2024-01-01 → الراتب: 5000 جنيه
2. 2024-06-01 → الراتب: 6000 جنيه (زيادة)
3. 2024-12-01 → الراتب: 7000 جنيه (زيادة أخرى)

عند حساب راتب يناير 2024:
→ يستخدم السجل #1 (effective_from = 2024-01-01)

عند حساب راتب يوليو 2024:
→ يستخدم السجل #2 (effective_from = 2024-06-01)

عند حساب راتب ديسمبر 2024:
→ يستخدم السجل #3 (effective_from = 2024-12-01)
```

---

## 🛠️ كيفية الاستخدام

### **1. إضافة سجل تعويض جديد**

#### **الطريقة الأولى: من صفحة الموظف**
1. اذهب إلى صفحة الموظف
2. ابحث عن قسم "سجلات التعويض" أو "Salary History"
3. اضغط على "إضافة سجل جديد"
4. املأ البيانات:
   - **تاريخ بدء التطبيق**: تاريخ بدء سريان هذا التعويض
   - **الراتب الأساسي**: الراتب الأساسي الجديد
   - **الحوافز**: الحوافز (اختياري)
   - **معدل العمل الإضافي**: معدل ساعة العمل الإضافي (اختياري)
   - **الحصة الشهرية من الإجازات**: عدد أيام الإجازة الشهرية (اختياري)
   - **مكونات الراتب**: مكونات إضافية بصيغة JSON (اختياري)
   - **ملاحظات**: أي ملاحظات (اختياري)

#### **الطريقة الثانية: برمجيًا**
```php
EmployeeSalaryHistory::create([
    'employee_id' => $employee->id,
    'effective_from' => '2024-06-01',
    'base_salary' => 6000,
    'incentives' => 500,
    'overtime_rate' => 50.00,
    'monthly_leave_entitlement' => 2.5,
    'components' => [
        'transportation' => 200,
        'meal_allowance' => 300
    ],
    'created_by' => auth()->id(),
    'note' => 'زيادة راتب بعد التقييم السنوي'
]);
```

---

## 💡 كيف يتم استخدام السجلات في حساب الرواتب؟

### **عند توليد الراتب الشهري:**

1. **النظام يحدد التاريخ المرجعي:**
   ```php
   $snapshotDate = Carbon::create($year, $month, 1)->startOfMonth();
   // مثال: 2024-06-01 لشهر يونيو 2024
   ```

2. **البحث عن السجل المناسب:**
   ```php
   $history = EmployeeSalaryHistory::where('employee_id', $employee->id)
       ->where('effective_from', '<=', $snapshotDate)
       ->orderByDesc('effective_from')
       ->first();
   ```

3. **استخدام القيم من السجل:**
   - إذا وُجد سجل: يستخدم القيم من السجل
   - إذا لم يُوجد سجل: يستخدم القيم الحالية من جدول `employees`

### **مثال عملي:**

```
الموظف: سارة أحمد
تاريخ التعيين: 2023-01-15

سجلات التعويض:
1. 2023-01-15 → base_salary: 4000, incentives: 200
2. 2024-03-01 → base_salary: 5000, incentives: 300
3. 2024-09-01 → base_salary: 6000, incentives: 400

عند توليد راتب فبراير 2024:
→ snapshotDate = 2024-02-01
→ يستخدم السجل #1 (effective_from = 2023-01-15)
→ الراتب = 4000 + 300 = 4300 جنيه

عند توليد راتب مارس 2024:
→ snapshotDate = 2024-03-01
→ يستخدم السجل #2 (effective_from = 2024-03-01)
→ الراتب = 5000 + 300 = 5300 جنيه

عند توليد راتب سبتمبر 2024:
→ snapshotDate = 2024-09-01
→ يستخدم السجل #3 (effective_from = 2024-09-01)
→ الراتب = 6000 + 400 = 6400 جنيه
```

---

## 📊 الحقول التفصيلية

### **1. effective_from (تاريخ بدء التطبيق)**
- **الوظيفة**: يحدد متى يبدأ سريان هذا التعويض
- **مهم جداً**: يجب أن يكون فريدًا أو متسلسلاً منطقيًا
- **مثال**: إذا كان الموظف حصل على زيادة في 15 يونيو، ضع `effective_from = 2024-06-15`

### **2. base_salary (الراتب الأساسي)**
- **الوظيفة**: الراتب الأساسي للموظف
- **يُستخدم في**: حساب الراتب الإجمالي
- **مثال**: 5000 جنيه

### **3. incentives (الحوافز)**
- **الوظيفة**: الحوافز الشهرية الثابتة
- **يُستخدم في**: حساب الراتب الإجمالي
- **مثال**: 500 جنيه

### **4. overtime_rate (معدل العمل الإضافي)**
- **الوظيفة**: معدل ساعة العمل الإضافي
- **يُستخدم في**: حساب مبلغ العمل الإضافي
- **مثال**: 50.00 جنيه/ساعة

### **5. monthly_leave_entitlement (الحصة الشهرية من الإجازات)**
- **الوظيفة**: عدد أيام الإجازة الممنوحة شهريًا
- **يُستخدم في**: حساب رصيد الإجازات
- **مثال**: 2.5 يوم/شهر

### **6. components (مكونات الراتب)**
- **النوع**: JSON Array
- **الوظيفة**: مكونات إضافية للراتب
- **مثال**:
```json
{
    "transportation": 200,
    "meal_allowance": 300,
    "housing_allowance": 500
}
```

---

## 🔄 سيناريوهات الاستخدام

### **السيناريو 1: زيادة راتب**
```
الموظف: محمد علي
الراتب الحالي: 5000 جنيه
التاريخ: 2024-06-01

الإجراء:
1. إضافة سجل جديد:
   - effective_from: 2024-06-01
   - base_salary: 6000 (زيادة 1000)
   - incentives: 500 (نفس القيمة)
   - note: "زيادة راتب بعد التقييم"

النتيجة:
- رواتب يناير-مايو 2024: تستخدم الراتب القديم (5000)
- رواتب يونيو 2024 فما بعد: تستخدم الراتب الجديد (6000)
```

### **السيناريو 2: تغيير الحوافز**
```
الموظف: فاطمة أحمد
الراتب: 4000 جنيه
الحوافز الحالية: 300 جنيه
التاريخ: 2024-09-01

الإجراء:
1. إضافة سجل جديد:
   - effective_from: 2024-09-01
   - base_salary: 4000 (نفس القيمة)
   - incentives: 500 (زيادة 200)
   - note: "زيادة الحوافز"

النتيجة:
- رواتب أغسطس 2024 فما قبل: الراتب = 4000 + 300 = 4300
- رواتب سبتمبر 2024 فما بعد: الراتب = 4000 + 500 = 4500
```

### **السيناريو 3: تغيير معدل العمل الإضافي**
```
الموظف: خالد محمود
معدل العمل الإضافي الحالي: 40 جنيه/ساعة
التاريخ: 2024-12-01

الإجراء:
1. إضافة سجل جديد:
   - effective_from: 2024-12-01
   - base_salary: 5000 (نفس القيمة)
   - incentives: 400 (نفس القيمة)
   - overtime_rate: 50.00 (زيادة)
   - note: "زيادة معدل العمل الإضافي"

النتيجة:
- العمل الإضافي قبل ديسمبر: 40 جنيه/ساعة
- العمل الإضافي من ديسمبر: 50 جنيه/ساعة
```

### **السيناريو 4: تغيير الحصة الشهرية من الإجازات**
```
الموظف: نورا سعيد
الحصة الحالية: 2 يوم/شهر
التاريخ: 2024-07-01

الإجراء:
1. إضافة سجل جديد:
   - effective_from: 2024-07-01
   - base_salary: 4500 (نفس القيمة)
   - monthly_leave_entitlement: 2.5 (زيادة)
   - note: "زيادة الحصة الشهرية من الإجازات"

النتيجة:
- قبل يوليو: الحصة = 2 يوم/شهر
- من يوليو: الحصة = 2.5 يوم/شهر
```

---

## ⚙️ الدوال البرمجية

### **1. getCompensationForDate()**
```php
// الحصول على سجل التعويض لتاريخ معين
$date = Carbon::create(2024, 6, 1);
$compensation = $employee->getCompensationForDate($date);

// النتيجة: سجل التعويض الأحدث حيث effective_from <= 2024-06-01
```

### **2. getCurrentCompensationAttribute**
```php
// الحصول على سجل التعويض الحالي
$current = $employee->current_compensation;

// النتيجة: سجل التعويض الأحدث حيث effective_from <= اليوم
```

### **3. resolveCompensationForDate() (في PayrollController)**
```php
// حل سجل التعويض وإرجاع مصفوفة منظمة
$comp = $this->resolveCompensationForDate($employee, $date);

// النتيجة:
[
    'base' => 5000,
    'incentives' => 500,
    'overtime_rate' => 50.00,
    'monthly_leave_entitlement' => 2.5,
    'components' => [
        'transportation' => 200,
        'meal_allowance' => 300
    ],
    'gross' => 6000 // إجمالي الراتب
]
```

---

## 🎯 الفوائد الرئيسية

### **1. دقة تاريخية**
- ✅ الحفاظ على سجل دقيق لتغييرات الراتب
- ✅ إمكانية حساب الرواتب التاريخية بدقة
- ✅ تتبع التغييرات عبر الزمن

### **2. مرونة في التغييرات**
- ✅ إمكانية تغيير الراتب في أي وقت
- ✅ التغييرات تُطبق من تاريخ محدد
- ✅ لا يؤثر على الرواتب السابقة

### **3. حساب دقيق للرواتب**
- ✅ عند توليد راتب لشهر معين، يستخدم القيم الصحيحة لذلك الشهر
- ✅ حتى لو تغير الراتب لاحقًا، الرواتب السابقة تبقى صحيحة

### **4. تتبع التغييرات**
- ✅ معرفة من أنشأ السجل (`created_by`)
- ✅ ملاحظات توضح سبب التغيير (`note`)
- ✅ تاريخ التغيير (`effective_from`)

---

## ⚠️ ملاحظات مهمة

### **1. ترتيب السجلات**
- السجلات يجب أن تكون مرتبة حسب `effective_from`
- السجل الأحدث (الأقرب للتاريخ المطلوب) هو الذي يُستخدم

### **2. عدم التداخل**
- يُفضل عدم وجود سجلات متداخلة
- كل سجل يجب أن يكون له `effective_from` فريد أو متسلسل

### **3. القيم الافتراضية**
- إذا لم يُوجد سجل تعويض لتاريخ معين، النظام يستخدم القيم من جدول `employees`
- هذا يضمن عدم وجود أخطاء في الحسابات

### **4. المكونات الإضافية**
- مكونات الراتب يمكن أن تكون في السجل (`components` JSON)
- أو في العلاقة (`salaryComponents`)
- أو في الحقول الثابتة (`component_1` إلى `component_7`)
- النظام يبحث في كل هذه المصادر بالترتيب

---

## 📝 مثال شامل

```
الموظف: يوسف يوسف
تاريخ التعيين: 2023-01-01

سجلات التعويض:

1. 2023-01-01 (تاريخ التعيين)
   - base_salary: 3000
   - incentives: 200
   - overtime_rate: 30.00
   - monthly_leave_entitlement: 2
   - note: "راتب التعيين الأولي"

2. 2023-07-01 (بعد 6 أشهر)
   - base_salary: 3500
   - incentives: 300
   - overtime_rate: 35.00
   - monthly_leave_entitlement: 2
   - note: "زيادة راتب بعد فترة التجربة"

3. 2024-01-01 (بعد سنة)
   - base_salary: 4000
   - incentives: 400
   - overtime_rate: 40.00
   - monthly_leave_entitlement: 2.5
   - note: "زيادة راتب سنوية"

4. 2024-06-01 (ترقية)
   - base_salary: 5000
   - incentives: 500
   - overtime_rate: 50.00
   - monthly_leave_entitlement: 2.5
   - components: {"transportation": 200, "meal": 300}
   - note: "ترقية إلى منصب أعلى"

عند توليد الرواتب:

- راتب يناير 2023:
  → يستخدم السجل #1
  → الراتب = 3000 + 200 = 3200 جنيه

- راتب يوليو 2023:
  → يستخدم السجل #2
  → الراتب = 3500 + 300 = 3800 جنيه

- راتب يناير 2024:
  → يستخدم السجل #3
  → الراتب = 4000 + 400 = 4400 جنيه

- راتب يونيو 2024:
  → يستخدم السجل #4
  → الراتب = 5000 + 500 + 200 + 300 = 6000 جنيه
```

---

## 🔧 الصيانة والإدارة

### **إضافة سجل جديد:**
1. اذهب إلى صفحة الموظف
2. ابحث عن قسم "سجلات التعويض"
3. اضغط "إضافة سجل جديد"
4. املأ البيانات واختر `effective_from` المناسب

### **تعديل سجل موجود:**
1. اذهب إلى صفحة الموظف
2. ابحث عن السجل المطلوب
3. اضغط "تعديل"
4. عدّل البيانات

### **حذف سجل:**
- ⚠️ **احذر**: حذف سجل قد يؤثر على حسابات الرواتب التاريخية
- يُفضل تعديل السجل بدلاً من حذفه

---

## 📊 الخلاصة

**سجلات التعويض** هي نظام قوي لتتبع تغييرات الراتب عبر الزمن. النظام:
- ✅ يحافظ على دقة الحسابات التاريخية
- ✅ يسمح بتغيير الراتب في أي وقت
- ✅ يضمن استخدام القيم الصحيحة لكل شهر
- ✅ يوفر تتبعًا كاملاً للتغييرات

**الاستخدام الأمثل:**
- أضف سجل جديد عند أي تغيير في الراتب
- استخدم `effective_from` بدقة
- أضف ملاحظات توضح سبب التغيير
- راجع السجلات بانتظام للتأكد من صحتها

