# تعليمات مسح Cache لحل مشكلة 404

## المشكلة:
عند الوصول إلى `/leaves/guide` يظهر خطأ 404

## الحل:

### 1. مسح Route Cache:
```bash
php artisan route:clear
```

### 2. مسح جميع أنواع Cache:
```bash
php artisan cache:clear
php artisan config:clear
php artisan view:clear
php artisan route:clear
```

### 3. إعادة تحميل Routes:
```bash
php artisan route:list | grep leaves.guide
```

يجب أن ترى:
```
GET|HEAD  leaves/guide ................ leaves.guide › LeaveController@guide
```

### 4. إذا استمرت المشكلة:

#### أ) تحقق من أنك مسجل دخول:
- Route محمي بـ `auth` middleware
- يجب أن تكون مسجل دخول

#### ب) تحقق من الصلاحيات:
- Route يستخدم `authorize('viewAny', Leave::class)`
- يجب أن يكون لديك صلاحية عرض الإجازات

#### ج) جرب الوصول مباشرة:
- جرب: `http://your-domain/leaves/guide`
- أو: `{{ route('leaves.guide') }}`

### 5. التحقق من Route:
افتح `routes/web.php` وتأكد من وجود:
```php
Route::get('leaves/guide', [LeaveController::class, 'guide'])->name('leaves.guide');
```

**قبل** `Route::resource('leaves', LeaveController::class);`

### 6. التحقق من Controller:
افتح `app/Http/Controllers/LeaveController.php` وتأكد من وجود:
```php
public function guide()
{
    $this->authorize('viewAny', Leave::class);
    
    return view('leaves.guide');
}
```

### 7. التحقق من View:
تأكد من وجود الملف:
`resources/views/leaves/guide.blade.php`

---

## إذا استمرت المشكلة بعد كل هذا:

1. تحقق من سجلات الأخطاء:
   - `storage/logs/laravel.log`

2. تحقق من أن Apache/Nginx يعمل بشكل صحيح

3. جرب إعادة تشغيل الخادم

